/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInfoBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.ArrayList;
import java.util.Vector;

public class RoutingBean
extends PanelBean
implements SettingsConstants {
    private String m_sGatewayDevice;
    private ValueDescriptor[] m_cdGatewayDevice;
    private NetworkInfo _networkInfo;
    private int[] m_iRouteInfoTableSelection = new int[1];
    private ItemDescriptor[] m_idRouteInfoTable;
    private ColumnDescriptor[] m_cdRouteInfoTableStructure;
    private boolean m_bRoutedEnabled;
    private Vector TTypeVector;
    private Vector TDestinationVector;
    private Vector TGatewayVector;
    private Vector TSubnetMaskVector;
    private Vector TInterfaceVector;
    private ArrayList TType;
    private ArrayList TDestination;
    private ArrayList TGateway;
    private ArrayList TSubnetMask;
    private ArrayList TInterface;
    private String m_sDefaultGateway;
    private String defaultGateway;
    private String gatewayDevice;
    private boolean routedEnabled;
    private int rowSelected;
    private String[] lanList;
    private static final String TRACE_MASKT = "XSETROUT";
    private static final String TRACE_MASKF = "XSETROUF";
    private static final String TRACE_MASKD = "XSETROUD";
    private boolean tableHasChanged = false;
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "RoutingBean");
    protected LocalizableText invalidValueMsg = new LocalizableText(CommonResourceBundle.getBundleName(), "formatter.badvalue", null);
    private String command = "";

    public ColumnDescriptor[] getRouteInfoTableRowStructure() {
        return null;
    }

    public int getRouteInfoTableRowStatus() {
        return 3;
    }

    public int getRouteInfoTableRowCount() {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.getRouteInfoTableRowCount()");
        int retCount = this.m_idRouteInfoTable.length / 5;
        Trace.trace(TRACE_MASKT, "Number of rows in the table is " + retCount);
        return retCount;
    }

    public ItemDescriptor[] getRouteInfoTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.getRouteInfoTableRowAt, index = " + index);
        ItemDescriptor[] rowAt = new ItemDescriptor[]{new ItemDescriptor(), new ItemDescriptor(), new ItemDescriptor(), new ItemDescriptor(), new ItemDescriptor()};
        if (this.getRouteInfoTableRowCount() > 0) {
            rowAt[0] = this.m_idRouteInfoTable[index * 5];
            rowAt[1] = this.m_idRouteInfoTable[index * 5 + 1];
            rowAt[2] = this.m_idRouteInfoTable[index * 5 + 2];
            rowAt[3] = this.m_idRouteInfoTable[index * 5 + 3];
            rowAt[4] = this.m_idRouteInfoTable[index * 5 + 4];
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.getRouteInfoTableRowAt()");
        return rowAt;
    }

    public void setRouteInfoTableRowAt(int index, ItemDescriptor[] items) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.setRouteInfoTableRowAt , index = " + index);
        this.m_idRouteInfoTable[index * 5] = items[0];
        this.m_idRouteInfoTable[index * 5 + 1] = items[1];
        this.m_idRouteInfoTable[index * 5 + 2] = items[2];
        this.m_idRouteInfoTable[index * 5 + 3] = items[3];
        this.m_idRouteInfoTable[index * 5 + 4] = items[4];
        Trace.trace(TRACE_MASKT, "<- RoutingBean.setRouteInfoTableRowAt()");
    }

    public int[] getRouteInfoTableSelection() {
        Trace.trace(TRACE_MASKT, "in getRouteInfoTableSelection, m_iRouteInfoTableSelection[0] = " + this.m_iRouteInfoTableSelection[0]);
        return this.m_iRouteInfoTableSelection;
    }

    public void setRouteInfoTableSelection(int[] selected) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.setRouteInfoTableSelection");
        if (selected.length == 0) {
            Trace.trace(TRACE_MASKT, "in setRouteInfoTableSelection- selected = null");
            this.m_iRouteInfoTableSelection = this.getRouteInfoTableSelection();
            this.refreshMyElements();
        } else {
            ItemDescriptor[] selectedRow = this.getRouteInfoTableRowAt(selected[0]);
            Trace.trace(TRACE_MASKT, "Row selected is [" + selectedRow[0].getTitle() + "] [" + selectedRow[1].getTitle() + "] [" + selectedRow[2].getTitle() + "] [" + selectedRow[3].getTitle() + "] [" + selectedRow[4].getTitle() + "]\n");
            this.m_iRouteInfoTableSelection = selected;
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.setRouteInfoTableSelection");
    }

    public void setMYRouteInfoTableSelection(int[] selected) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.setMYRouteInfoTableSelection");
        if (selected.length != 0) {
            ItemDescriptor[] selectedRow = this.getRouteInfoTableRowAt(selected[0]);
            Trace.trace(TRACE_MASKT, "Row selected is [" + selectedRow[0].getTitle() + "] [" + selectedRow[1].getTitle() + "] [" + selectedRow[2].getTitle() + "] [" + selectedRow[3].getTitle() + "] [" + selectedRow[4].getTitle() + "]\n");
        } else {
            Trace.trace(TRACE_MASKT, "in setMYRouteInfoTableSelection- selected = null");
        }
        this.m_iRouteInfoTableSelection = selected;
        Trace.trace(TRACE_MASKT, "<- RoutingBean.setMYRouteInfoTableSelection");
    }

    public String getDefaultGateway() {
        return this.m_sDefaultGateway;
    }

    public void setDefaultGateway(String s) throws IllegalUserDataException {
        if (!NetworkInfo.isValidIPAddr(s)) {
            throw new IllegalUserDataException(this.invalidValueMsg.toString() + "\n[" + s + "]");
        }
        this.m_sDefaultGateway = s;
    }

    public String getGatewayDevice() {
        Trace.trace(TRACE_MASKT, "RoutingBean: getGatewayDevice run: " + this.m_sGatewayDevice);
        return this.m_sGatewayDevice;
    }

    public void setGatewayDevice(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "RoutingBean: setGatewayDevice run: " + s);
        if (s.startsWith("eth") || s.startsWith("tr")) {
            this.m_sGatewayDevice = s;
        } else {
            this.m_sGatewayDevice = "-";
            Trace.trace(TRACE_MASKT, "GatewayDevice was 'any'; corrected to '-'");
        }
    }

    public ValueDescriptor[] getGatewayDeviceList() {
        return this.m_cdGatewayDevice;
    }

    public boolean isRoutedEnabled() {
        return this.m_bRoutedEnabled;
    }

    public void setRoutedEnabled(boolean b) throws IllegalUserDataException {
        this.m_bRoutedEnabled = b;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.save()");
        this.storeMyElements();
        int i = 0;
        while (i < this.m_idRouteInfoTable.length) {
            Trace.trace(TRACE_MASKT, "table element[" + i + "]= " + this.m_idRouteInfoTable[i].getTitle() + " " + this.m_idRouteInfoTable[i].getName());
            ++i;
        }
        int j = 0;
        while (j < this.m_iRouteInfoTableSelection.length) {
            Trace.trace(TRACE_MASKT, "selected " + this.m_iRouteInfoTableSelection[j]);
            ++j;
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.prepare()");
        this.buildTable();
        this.tableHasChanged = false;
        int[] selection = new int[]{0};
        this.setMYRouteInfoTableSelection(selection);
        this.setDefaultGateway(this.defaultGateway);
        this.setGatewayDevice(this.gatewayDevice);
        this.setRoutedEnabled(this.routedEnabled);
        this.m_cdGatewayDevice = new ValueDescriptor[this.lanList.length];
        int i = 0;
        while (i < this.lanList.length) {
            this.m_cdGatewayDevice[i] = new ValueDescriptor(this.lanList[i], this.lanList[i]);
            Trace.trace(TRACE_MASKT, "m_cdGatewayDevice[" + i + "] = " + this.lanList[i]);
            ++i;
        }
        this.userTaskManager.refreshContainer(this.getMountPrefix() + "RouteInfoTable");
        this.refreshMyElements();
        PanelTaskletRequest request = new PanelTaskletRequest("routingpanel");
        request.setData("panel", "routingpanel");
        request.setData("action", "preparedone");
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKT, "<- RoutingBean.prepare()");
    }

    public void buildTable() {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.buildTable()");
        int cells = 5 * this.TType.size();
        Trace.trace(TRACE_MASKT, "TType.size() = " + this.TType.size() + "; # cells = " + cells);
        this.m_idRouteInfoTable = new ItemDescriptor[cells];
        int i = 0;
        while (i < cells) {
            this.m_idRouteInfoTable[i] = new ItemDescriptor();
            ++i;
        }
        this.m_cdRouteInfoTableStructure = new ColumnDescriptor[0];
        this.m_iRouteInfoTableSelection = new int[0];
        ItemDescriptor[] row = new ItemDescriptor[5];
        int i2 = 0;
        while (i2 < this.TType.size()) {
            row[0] = new ItemDescriptor("one" + String.valueOf(i2), (String)this.TType.get(i2));
            row[1] = new ItemDescriptor("two" + String.valueOf(i2), (String)this.TDestination.get(i2));
            row[2] = new ItemDescriptor("three" + String.valueOf(i2), (String)this.TGateway.get(i2));
            row[3] = new ItemDescriptor("four" + String.valueOf(i2), (String)this.TSubnetMask.get(i2));
            row[4] = new ItemDescriptor("five" + String.valueOf(i2), (String)this.TInterface.get(i2));
            this.setRouteInfoTableRowAt(i2, row);
            ++i2;
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.buildTable()");
    }

    public void addRow(int rowNumber, ArrayList rowData) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.addRow, rowNumber = " + rowNumber + "; rowData.get(0) = " + rowData.get(0));
        if (rowData.get(0).equals("afterButton") && this.getRouteInfoTableRowCount() != 0) {
            ++rowNumber;
        }
        if (this.TType.size() == 0) {
            rowNumber = 0;
        }
        this.TType.add(rowNumber, rowData.get(1));
        this.TDestination.add(rowNumber, rowData.get(2));
        this.TGateway.add(rowNumber, rowData.get(3));
        this.TSubnetMask.add(rowNumber, rowData.get(4));
        this.TInterface.add(rowNumber, rowData.get(5));
        this.buildTable();
        int[] selection = new int[]{rowNumber};
        this.setMYRouteInfoTableSelection(selection);
        Trace.trace(TRACE_MASKT, "<- RoutingBean.addRow()");
    }

    public void changeRow(int rowNumber, ArrayList rowData) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.changeRow, rowNumber = " + rowNumber);
        this.TType.set(rowNumber, rowData.get(1));
        this.TDestination.set(rowNumber, rowData.get(2));
        this.TGateway.set(rowNumber, rowData.get(3));
        this.TSubnetMask.set(rowNumber, rowData.get(4));
        this.TInterface.set(rowNumber, rowData.get(5));
        this.buildTable();
        int[] selection = new int[]{rowNumber};
        this.setMYRouteInfoTableSelection(selection);
        Trace.trace(TRACE_MASKT, "<- RoutingBean.changeRow()");
    }

    public void deleteRow() {
        int rowSelected = this.m_iRouteInfoTableSelection[0];
        Trace.trace(TRACE_MASKT, "-> RoutingBean.deleteRow, rowSelected = " + rowSelected + ";  m_iRouteInfoTableSelection[0] = " + this.m_iRouteInfoTableSelection[0]);
        int numrows = this.getRouteInfoTableRowCount();
        if (numrows > 0) {
            ArrayList<ItemDescriptor[]> rowData = new ArrayList<ItemDescriptor[]>(numrows - 1);
            int i = 0;
            while (i < numrows) {
                if (i != rowSelected) {
                    rowData.add(this.getRouteInfoTableRowAt(i));
                } else {
                    this.TType.remove(i);
                    this.TDestination.remove(i);
                    this.TGateway.remove(i);
                    this.TSubnetMask.remove(i);
                    this.TInterface.remove(i);
                }
                ++i;
            }
            this.m_idRouteInfoTable = new ItemDescriptor[this.m_idRouteInfoTable.length - 5];
            int i2 = 0;
            while (i2 < numrows - 1) {
                this.setRouteInfoTableRowAt(i2, (ItemDescriptor[])rowData.get(i2));
                ++i2;
            }
            int[] rowSel = new int[]{rowSelected - 1};
            if (rowSelected != 0) {
                this.setMYRouteInfoTableSelection(rowSel);
            }
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.deleteRow()");
    }

    public void panelAction(TaskActionEvent event) {
        this.command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> RoutingBean.panelAction():  " + this.command);
        Object uiExc = null;
        try {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            RoutingBean beans = this;
            Object[] allBeans = utm.getDataObjects();
            String myBeanName = this.getClass().getName();
            int i = 0;
            while (i < allBeans.length) {
                String beanName = allBeans[i].getClass().getName();
                if (beanName.equals(myBeanName)) {
                    beans = (RoutingBean)utm.getDataObjects()[i];
                }
                ++i;
            }
            this.rowSelected = beans.getRouteInfoTableSelection()[0];
            ArrayList<String> rowData = new ArrayList<String>();
            PanelTaskletRequest request = new PanelTaskletRequest("routingpanel");
            if (this.command.endsWith("newButton")) {
                Trace.trace(TRACE_MASKT, "NEW_BUTTON pressed! Row selected = " + this.rowSelected);
                request.setData("panel", "routingpanel");
                request.setData("action", "newButton");
                request.setData("data", rowData);
                this.postTaskletRequest(request);
            } else if (this.command.endsWith("changeButton")) {
                Trace.trace(TRACE_MASKT, "CHANGE_BUTTON pressed! Row selected = " + this.rowSelected);
                if (this.getRouteInfoTableRowCount() != 0) {
                    ItemDescriptor[] idArray = this.getRouteInfoTableRowAt(this.rowSelected);
                    int i2 = 0;
                    while (i2 < 5) {
                        rowData.add(idArray[i2].getTitle());
                        Trace.trace(TRACE_MASKT, " idArray[i].getTitle() = " + idArray[i2].getTitle());
                        ++i2;
                    }
                    request.setData("panel", "routingpanel");
                    request.setData("action", "changeButton");
                    request.setData("data", rowData);
                    this.postTaskletRequest(request);
                } else {
                    Trace.trace(TRACE_MASKF, "CHANGE_BUTTON pressed, but table empty - ignore.");
                }
            } else if (this.command.endsWith("deleteButton")) {
                Trace.trace(TRACE_MASKT, "DELETE_BUTTON pressed! Row selected = " + this.rowSelected);
                beans.deleteRow();
                this.refreshMyElements();
                this.tableHasChanged = true;
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 16, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> RoutingBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("routingpanel");
        if (command.endsWith("okButton") || command.endsWith("applyButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (RoutingBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            int numrows = this.TType.size();
            this.TTypeVector = new Vector(numrows);
            this.TDestinationVector = new Vector(numrows);
            this.TGatewayVector = new Vector(numrows);
            this.TSubnetMaskVector = new Vector(numrows);
            this.TInterfaceVector = new Vector(numrows);
            boolean defaultGatewaySetInTable = false;
            int i = 0;
            while (i < numrows) {
                this.TTypeVector.add(i, (String)this.TType.get(i));
                this.TDestinationVector.add(i, (String)this.TDestination.get(i));
                this.TGatewayVector.add(i, (String)this.TGateway.get(i));
                this.TSubnetMaskVector.add(i, (String)this.TSubnetMask.get(i));
                this.TInterfaceVector.add(i, (String)this.TInterface.get(i));
                String thisType = (String)this.TType.get(i);
                String thisInterface = (String)this.TInterface.get(i);
                Trace.trace(TRACE_MASKT, "thisType = [" + thisType + "]; thisInterface = [" + thisInterface + "]");
                if (thisType.equals("Default")) {
                    defaultGatewaySetInTable = true;
                    this._networkInfo.setDefaultGateway((String)this.TGateway.get(i));
                    Trace.trace(TRACE_MASKT, "update DefaultGateway = [" + (String)this.TGateway.get(i) + "]");
                    if (thisInterface.startsWith("eth") || thisInterface.startsWith("tr")) {
                        this._networkInfo.setGatewayDev((String)this.TInterface.get(i));
                    } else {
                        this._networkInfo.setGatewayDev("-");
                    }
                    Trace.trace(TRACE_MASKT, "update GatewayDev = [" + (String)this.TInterface.get(i) + "]");
                }
                ++i;
            }
            this._networkInfo.setTypeVector(this.TTypeVector);
            this._networkInfo.setDestinationVector(this.TDestinationVector);
            this._networkInfo.setGatewayVector(this.TGatewayVector);
            this._networkInfo.setSubnetMaskVector(this.TSubnetMaskVector);
            this._networkInfo.setInterfaceVector(this.TInterfaceVector);
            if (!defaultGatewaySetInTable) {
                this._networkInfo.setDefaultGateway(this.m_sDefaultGateway);
                if (this.m_sGatewayDevice.startsWith("eth") || this.m_sGatewayDevice.startsWith("tr")) {
                    this._networkInfo.setGatewayDev(this.m_sGatewayDevice);
                } else {
                    this._networkInfo.setGatewayDev("-");
                }
            }
            this._networkInfo.setRoutedEnabled(this.m_bRoutedEnabled);
            request.setData("panel", "routingpanel");
            request.setData("action", "dataupdates");
            request.setData("dataupdates", this._networkInfo);
            this.postTaskletRequest(request);
        } else if (command.endsWith("cancelButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (RoutingBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            if (this._networkInfo.isRoutedEnabled() != this.m_bRoutedEnabled || this.tableHasChanged) {
                ((NetworkInfoBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKT, "RoutingBean believes data has changed");
            }
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.parentalAction()");
    }

    public void update(Object updates) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.update() processing command: " + this.command);
        ArrayList rowData = (ArrayList)updates;
        this.rowSelected = this.m_iRouteInfoTableSelection[0];
        this.tableHasChanged = true;
        Trace.trace(TRACE_MASKF, "rowSelected = " + this.rowSelected);
        Trace.trace(TRACE_MASKF, "RoutingBean.update: rowData.get(0) " + rowData.get(0));
        Trace.trace(TRACE_MASKF, "RoutingBean.update: rowData.get(1) " + rowData.get(1));
        Trace.trace(TRACE_MASKF, "RoutingBean.update: rowData.get(2) " + rowData.get(2));
        Trace.trace(TRACE_MASKF, "RoutingBean.update: rowData.get(3) " + rowData.get(3));
        Trace.trace(TRACE_MASKF, "RoutingBean.update: rowData.get(4) " + rowData.get(4));
        Trace.trace(TRACE_MASKF, "RoutingBean.update: rowData.get(5) " + rowData.get(5));
        try {
            if (this.command.endsWith("newButton")) {
                Trace.trace(TRACE_MASKT, "NEW_BUTTON update; Row selected = " + this.rowSelected);
                this.addRow(this.rowSelected, rowData);
                this.userTaskManager.refreshElement(this.getMountPrefix() + "RouteInfoTable");
            } else {
                Trace.trace(TRACE_MASKT, "CHANGE_BUTTON update; Row selected = " + this.rowSelected);
                this.changeRow(this.rowSelected, rowData);
                this.userTaskManager.refreshElement(this.getMountPrefix() + "RouteInfoTable");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 9, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- RoutingBean.update()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DefaultGateway");
        this.userTaskManager.storeElement(this.getMountPrefix() + "RoutedEnabled");
        this.userTaskManager.storeElement(this.getMountPrefix() + "GatewayDevice");
        this.userTaskManager.storeElement(this.getMountPrefix() + "RouteInfoTable");
        Trace.trace(TRACE_MASKT, "<- RoutingBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DefaultGateway");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "RoutedEnabled");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "GatewayDevice");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "RouteInfoTable");
        Trace.trace(TRACE_MASKT, "<- RoutingBean.refreshMyElements()");
    }

    public void setNetworkInfo(NetworkInfo networkInfo, String[] lanAdapterList) {
        Trace.trace(TRACE_MASKT, "-> RoutingBean.setNetworkInfo()");
        this.TTypeVector = networkInfo.getTypeVector();
        this.TDestinationVector = networkInfo.getDestinationVector();
        this.TGatewayVector = networkInfo.getGatewayVector();
        this.TSubnetMaskVector = networkInfo.getSubnetMaskVector();
        this.TInterfaceVector = networkInfo.getInterfaceVector();
        int numrows = this.TTypeVector.size();
        this.TType = new ArrayList(numrows);
        this.TDestination = new ArrayList(numrows);
        this.TGateway = new ArrayList(numrows);
        this.TSubnetMask = new ArrayList(numrows);
        this.TInterface = new ArrayList(numrows);
        int i = 0;
        while (i < numrows) {
            this.TType.add(i, (String)this.TTypeVector.get(i));
            this.TDestination.add(i, (String)this.TDestinationVector.get(i));
            this.TGateway.add(i, (String)this.TGatewayVector.get(i));
            this.TSubnetMask.add(i, (String)this.TSubnetMaskVector.get(i));
            this.TInterface.add(i, (String)this.TInterfaceVector.get(i));
            ++i;
        }
        this.defaultGateway = networkInfo.getDefaultGateway();
        this.gatewayDevice = networkInfo.getGatewayDev();
        this.routedEnabled = networkInfo.isRoutedEnabled();
        Trace.trace(TRACE_MASKT, "DefaultGateway = " + this.defaultGateway);
        Trace.trace(TRACE_MASKT, "GatewayDevice = " + this.gatewayDevice);
        Trace.trace(TRACE_MASKT, "routedEnabled = " + this.routedEnabled);
        this.lanList = new String[lanAdapterList.length + 1];
        this.lanList[0] = new LocalizableText("com.ibm.hwmca.base.settings.network.res.NetworkRes", "RouteEntryPanelPulldown.TEXT").toString();
        int i2 = 1;
        while (i2 < lanAdapterList.length + 1) {
            this.lanList[i2] = lanAdapterList[i2 - 1];
            Trace.trace(TRACE_MASKT, "lanList[" + i2 + "] = " + this.lanList[i2]);
            ++i2;
        }
        this._networkInfo = networkInfo;
        Trace.trace(TRACE_MASKT, "<- RoutingBean.setNetworkInfo()");
    }
}

